<?php
$lang = session()->get('locale') == 'th' ? 'th' : 'en';
$rname = Route::currentRouteName();
?>
<!DOCTYPE html>
<html class="wide wow-animation" lang="en">

<head>
    <title>ฮี่ทงเทียนไท้</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, height=device-height, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <link rel="icon" href="<?php echo e(asset('images/logo/logo.png')); ?>" type="image/x-icon">
    <link rel="stylesheet" type="text/css"
        href="//fonts.googleapis.com/css?family=Montserrat:300,400,700%7CPoppins:300,400,500,700,900">
    <link rel="stylesheet" href="<?php echo e(asset('css/bootstrap.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/fonts.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/style.css')); ?>">
    <style>
        .ie-panel {
            display: none;
            background: #212121;
            padding: 10px 0;
            box-shadow: 3px 3px 5px 0 rgba(0, 0, 0, .3);
            clear: both;
            text-align: center;
            position: relative;
            z-index: 1;
        }

        html.ie-10 .ie-panel,
        html.lt-ie-10 .ie-panel {
            display: block;
        }

    </style>
    <script>
        var url = "<?php echo e(route('changeLang')); ?>";
       function langChange(){
            // alert(url)
            window.location.href = url + "?lang="+ document.getElementById("changeLang").value;
       };
    </script>
</head>

<body>
    
    <div class="preloader">
        <div class="preloader-body">
            <div class="cssload-container">
                <div class="cssload-speeding-wheel"></div>
            </div>
            <p>Loading...</p>
        </div>
    </div>

    <div class="page">
        <header class="section page-header">
            <!--RD Navbar-->
            <div class="rd-navbar-wrap">
                <nav class="rd-navbar rd-navbar-classic" data-layout="rd-navbar-fixed" data-sm-layout="rd-navbar-fixed"
                    data-md-layout="rd-navbar-fixed" data-md-device-layout="rd-navbar-fixed"
                    data-lg-layout="rd-navbar-static" data-lg-device-layout="rd-navbar-static"
                    data-xl-layout="rd-navbar-static" data-xl-device-layout="rd-navbar-static"
                    data-lg-stick-up-offset="46px" data-xl-stick-up-offset="46px" data-xxl-stick-up-offset="46px"
                    data-lg-stick-up="true" data-xl-stick-up="true" data-xxl-stick-up="true">
                    

                    <div class="rd-navbar-main-outer">
                        <div class="rd-navbar-main">
                            <!--RD Navbar Panel-->
                            <div class="rd-navbar-panel">
                                <!--RD Navbar Toggle-->
                                <button class="rd-navbar-toggle"
                                    data-rd-navbar-toggle=".rd-navbar-nav-wrap"><span></span></button>
                                <!--RD Navbar Brand-->
                                <div class="rd-navbar-brand">
                                    <!--Brand--><a class="brand" href="/">
                                        
                                            <img class="brand-logo-dark" src="<?php echo e(asset('images/logo/logo.png')); ?>"
                            alt="" width="auto" height="60" />
                                        </a>
                                </div>
                            </div>
                            <div class="rd-navbar-main-element">


                                <div class="rd-navbar-nav-wrap">
                                    <ul class="rd-navbar-nav">
                                        <li class="rd-nav-item <?php echo e($rname == 'home' ? 'active' : ''); ?>"><a
                                                class="rd-nav-link" href="/"><?php echo e(trans('home.Home')); ?></a>
                                        </li>
                                        <li class="rd-nav-item <?php echo e($rname == 'objective' ? 'active' : ''); ?>"><a
                                                class="rd-nav-link"
                                                href="<?php echo e(route('objective')); ?>">วัตถุประสงค์การสร้าง</a>
                                        </li>
                                        <li class="rd-nav-item <?php echo e($rname == 'dodate' ? 'active' : ''); ?>"><a
                                                class="rd-nav-link" href=" <?php echo e(route('dodate')); ?>">ร่วมบริจาค</a>
                                        </li>
                                        <li class="rd-nav-item <?php echo e($rname == 'donor' ? 'active' : ''); ?>"><a
                                                class="rd-nav-link" href=" <?php echo e(route('donor')); ?>">นามผู้บริจาค</a>
                                        </li>
                                        <li class="rd-nav-item <?php echo e($rname == 'contactUs' ? 'active' : ''); ?>"><a
                                                class="rd-nav-link" href=" <?php echo e(route('contactUs')); ?>">ติดต่อเรา</a>
                                        </li>
                                        <li class="rd-nav-item">
                                            <select class="form-control" id="changeLang" onchange="langChange()">
                                                <option value="en" <?php echo e($lang == 'en' ? 'selected' : ''); ?>>English
                                                </option>
                                                <option value="th" <?php echo e($lang == 'th' ? 'selected' : ''); ?>>Thai
                                                </option>
                                            </select>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </nav>
            </div>
        </header>
        <!--Main section-->
        <?php echo $__env->yieldContent('content'); ?>
        <!--Footer-->
        <footer class="section footer-classic section-sm">
            <div class="container">
                <div class="row row-30">
                    <div class="col-12 wow fadeInLeft text-center">
                        <!--Brand-->
                        <a class="brand" href="/">
                            <img src="<?php echo e(asset('images/logo/logo.png')); ?>"
                            alt="" width="100%" height="auto" />
                            </a>
                        <p class="footer-classic-description offset-top-0 offset-right-25">
                            มูลนิธิ ดร.เทียม โชควัฒนา <br>


ที่ตั้ง : บริษัท ไอ.ซี.ซี. อินเตอร์เนชั่นแนล จำกัด ( มหาชน ) เลขที่ 530 ซ.สาธุประดิษฐ์ 58 แขวงบางโพงพาง เขตยานนาวา กรุงเทพฯ 10120 <br> โทร. 0-2295-3392 (สายตรง) , 0-293-9000 ต่อ 110
                        </p>
                    </div>

                </div>
            </div>
            <div class="container wow fadeInUp" data-wow-delay=".4s">
                <div class="footer-classic-aside">
                    <p class="rights"><span>&copy;&nbsp;</span> 2022 All Rights Reserved. Design by Saha Pathana Inter-Holding (SPI) </p>

                </div>
            </div>
        </footer>
    </div>
    <div class="snackbars" id="form-output-global"></div>
    <script src="<?php echo e(asset('js/core.min.js')); ?> "></script>
    <script src="<?php echo e(asset('js/script.js')); ?>"></script>
    <!--coded by Drel-->
</body>

</html>
<?php /**PATH /Applications/project_valet/yitongtiantai/resources/views/layouts/app.blade.php ENDPATH**/ ?>